<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "packetcommands".
 *
 * @property int $id
 * @property int|null $task_id
 * @property string|null $command
 * @property string|null $usercommand
 * @property int|null $commandtype
 * @property string|null $result
 * @property int|null $step
 */
class Packetcommands extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'packetcommands';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['task_id', 'step'], 'default', 'value' => null],
            [['task_id', 'step'], 'integer'],
            [['command', 'usercommand', 'condition', 'packetcommandtype'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'task_id' => 'Task ID',
            'command' => 'Command',
            'usercommand' => 'Usercommand',
            'commandtype' => 'Commandtype',
            'result' => 'Result',
            'step' => 'Step',
        ];
    }

    public function newline($model)
    {
        $m = Packetcommands::find()->orderBy(['step' => SORT_DESC])->where(['task_id' => $model->id])->one();
        if(!$m){
            return 10;
        }else{
            return $m->step + 10;
        }
    }
}
